import { BASE_URL } from "../config";
import Toast from "react-native-simple-toast";

export const apiRequest = async (endpoint, method = "GET", body = null, isFormData=false) => {
    const apiUrl = `${BASE_URL}${endpoint}`;
    //console.log("apiurl== ", apiUrl);
    try {
        let headers ={
            Accept: 'application/json'
        }

        if(!isFormData){
            headers['Content-type'] = 'application/json'
        }

        let options = {
            method,
            headers,
        };

        if (body) {
            options.body = isFormData ? body : JSON.stringify(body);
        }
        
        const response = await fetch(apiUrl, options);
        
        const result = await response.json();
        //console.log(`${apiUrl} ${method} ${endpoint} Response API:`, result, options);
        if (result.status === 1) {
        
            if(result?.message)
            Toast.show(result?.message);

            return result.data;
        } else {
            //Toast.show(result.message || "Something went wrong");
            try {
                if(result?.errors?.[0]){
                    Toast.show(result?.errors?.[0]);
                } else if(result?.message) {
                    //Toast.show(result?.message);
                }
              } catch (error) {
                console.log('Toast error ApiService:', error);
              }
            return null;
        }
    } catch (error) {
        console.log(`Error in API NAME ${apiUrl}:`, error);
        Toast.show("Network error, please try again");
        return null;
    }
};
