import React, { useEffect, useState } from 'react';
import { View, Text, Alert } from 'react-native';
import Pusher from 'pusher-js/react-native';

const TaxiNotification = () => {
  const [ride, setRide] = useState(null);

  useEffect(() => {
    const pusher = new Pusher('local', {
      cluster: 'mt1',
      wsHost: '127.0.0.1',
      wsPort: 6001,
      forceTLS: false,
      disableStats: true,
    });

    const channel = pusher.subscribe('taxi-requests');

    channel.bind('new-ride', (data) => {
      setRide(data.ride);
      Alert.alert("🚖 New Ride!", `Pickup: ${data.ride.pickup} → Dropoff: ${data.ride.dropoff}`);
    });

    return () => {
      channel.unbind_all();
      channel.unsubscribe();
    };
  }, []);

  return (
    <View>
      {ride ? (
        <Text>New Ride: {ride.pickup} → {ride.dropoff}</Text>
      ) : (
        <Text>Waiting for rides...</Text>
      )}
    </View>
  );
};

export default TaxiNotification;
