import React, { useEffect, useState } from 'react';
import { View, Text, FlatList } from 'react-native';
import Pusher from 'pusher-js/react-native';

const CurrentRides = () => {
  const [rides, setRides] = useState([]);

  useEffect(() => {
    const pusher = new Pusher('local', {
      cluster: 'mt1',
      wsHost: '127.0.0.1',
      wsPort: 6001,
      forceTLS: false,
      disableStats: true,
    });

    const channel = pusher.subscribe('taxi-requests');

    channel.bind('new-ride', (data) => {
        console.log('datanew_ride== ', data);
      setRides((prevRides) => [...prevRides, data.ride]);
    });

    return () => {
      channel.unbind_all();
      channel.unsubscribe();
    };
  }, []);

  return (
    <View>
      <Text>🚖 Ongoing Rides</Text>
      <FlatList
        data={rides}
        keyExtractor={(item) => item.id.toString()}
        renderItem={({ item }) => (
          <View>
            <Text>Pickup: {item.pickup}</Text>
            <Text>Dropoff: {item.dropoff}</Text>
            <Text>Status: {item.status}</Text>
          </View>
        )}
      />
    </View>
  );
};

export default CurrentRides;
