import { StyleSheet, Text, View, Image, Modal, TouchableOpacity } from 'react-native'
import React, { useEffect, useRef, useState } from 'react'
import { fp, hp, wp } from '../../helpers/Dimensions'
import Buttonblack from '../../components/Buttonblack'
import { useNavigation } from '@react-navigation/native'
import { THUMBSUP } from '../../assets/Icon'
import { getInProcessRide, initiateRides, ridePaymentInitiatedFare } from '../../services/RideService'
import RideNew from '../../components/models/RideNew'

import { RIDESTATUSHASH } from '../../config';

const Paymentreceived = ({route}) => {
    const navigation = useNavigation()
    const ride_id = route?.params?.ride_id ?? null;
    const[ride_fare, set_ride_fare] = useState(null);
    const [activeModal, setActiveModal] = useState(null);
    const [modalData, setModalData] = useState(null);
    const [ride_status, set_ride_status] = useState(null);
    const [loading, setLoading] = useState(true);

    const intervalRef = useRef(null);


    useEffect(() => {
        paymentInitiatedFare()
        
        
        intervalRef.current = setInterval(fetchNewRide, 2000);
        

        return () => clearInterval(intervalRef.current);

    }, [])

    
////////////////////////////////////////
    const fetchNewRide = async () => {
        const initiateRidesResponse = await initiateRides();
        console.log("payment31=== ", ride_id, initiateRidesResponse);

        if (!initiateRidesResponse || initiateRidesResponse.length === 0) return;

        const payment_chk = initiateRidesResponse
            .filter(ride => 
                ride.id == ride_id &&
                (ride.status_name === 'PAYMENT_COMPLETE' || ride.status_name === 'COMPLETE')
        );

        if(payment_chk && payment_chk.length > 0){
            setLoading(false);
        }

        const filtered = initiateRidesResponse.filter(ride => ride.status_name === 'PENDING')
            .map(ride => ({
                        ...ride,
                        queued: 1,
            })
        );
        
        if(filtered.length > 0 ){
            console.log("payment45===", filtered)
            var filtered_ride = filtered[0];
            var modify_status_name = filtered_ride?.queued == 1 ? 'QUEUED' : '';

            const config = RIDESTATUSHASH[modify_status_name];
            console.log("payment47===", config);
            if (config) {
                setActiveModal(config.modal);
                setModalData(filtered_ride);
                clearInterval(intervalRef.current);
            }
        }

        
            
    }
////////////////////////////////////


    const handleModal = (data) => {
        console.log("Modal Action Triggered With:", data);
        setActiveModal(null);
    };

    const closeModal = () => {
        setActiveModal(null);
    };

    const paymentInitiatedFare = async () =>{
        const { ride_id } = route.params;
        console.log("payment-rideid=== ", ride_id);
        const rideFare = await ridePaymentInitiatedFare(ride_id);
        console.log("payment-rideidd=== ", rideFare);
        set_ride_fare(rideFare);
        
    }

    const acceptRideFunc = async (rideId) => {

    }

    const handleDecline = async(rideId) => {

    }

    return (
        <View style={styles.mainContainer}>
            <View style={styles.headerContainer}>
                <Text style={styles.txtNormalBold}>Make Payment </Text>
            </View>

            <View style={[styles.srcHeadContainer, { margin: 20 }]}>
                <Text style={styles.txtNormalBold}>Payment {ride_fare?.currency_icon}{ride_fare?.final_price}</Text>
            </View>
            <View style={styles.paymentContainer}>
                <View style={styles.listContainer}>
                    <Text style={styles.txtSmall}>From: </Text>
                    <Text style={styles.txtSmall}>{ride_fare?.from}</Text>
                </View>
                <View style={styles.greyline}></View>
                <View style={styles.listContainer}>
                    <Text style={styles.txtSmall}>Drop: </Text>
                    <Text style={styles.txtSmall}>{ride_fare?.drop}</Text>
                </View>
                <View style={styles.greyline}></View>
                <View style={styles.listContainer}>
                    <Text style={styles.txtSmall}>Distance</Text>
                    <Text style={styles.txtSmall}>{ride_fare?.distance}{ride_fare?.distance_unit}</Text>
                </View>
                <View style={styles.greyline}></View>
                <View style={styles.listContainer}>
                    <Text style={styles.txtSmall}>Start Time</Text>
                    <Text style={styles.txtSmall}>{ride_fare?.start_time}</Text>
                </View>
                <View style={styles.greyline}></View>
                <View style={styles.greyline}></View>
                <View style={styles.listContainer}>
                    <Text style={styles.txtSmall}>End Time</Text>
                    <Text style={styles.txtSmall}>{ride_fare?.end_time}</Text>
                </View>

                <View style={styles.greyline}></View>
                <View style={styles.listContainer}>
                    <Text style={styles.txtSmall}>Total Time</Text>
                    <Text style={styles.txtSmall}>{ride_fare?.total_time}</Text>
                </View>
            </View>

            {false ? (
            <>
                <View style={[styles.srcHeadContainer, { margin: 20 }]}>
                <Text style={styles.txtNormalBold}>Checking payment status...</Text>
            </View>
            </>
            ) : (
            <>
            <View style={styles.imgContainer}>
                <Image source={THUMBSUP} />
            </View>

            <View style={styles.costContainer}>
                <Text style={styles.textH5}>Success</Text>
                <Text style={styles.textH1}>You have received {ride_fare?.currency_icon}{ride_fare?.final_price}</Text>
            </View>

            <View style={styles.btnContainer}>
                <Buttonblack title="Feedback" wide="80" onPress={() => navigation.navigate("Feedback", {ride_id: ride_fare?.ride_id})} />
            </View>
            </>
        )}
           <RideNew
                    visible={activeModal === 'queued_ride'}
                    onClose={closeModal}
                    handleModal={handleModal}
                    data={modalData}
                    functionName={acceptRideFunc}
                    functionDelete={handleDecline}
                />

        </View>

        

    )
}

export default Paymentreceived

const styles = StyleSheet.create({
    mainContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(100),
        widht: wp(100)
    },
    headerContainer: {
        backgroundColor: "#FFC727",
        width: wp(100),
        height: hp(10),
        borderBottomEndRadius: 20,
        borderBottomLeftRadius: 20,
        flexDirection: "row",
        alignItems: "center",
        justifyContent: "flex-start",
        paddingLeft: 20
    },
    srcHeadContainer: {
        backgroundColor: "#FFFFFF",
        flexDirection: "row",
        justifyContent: "space-between",
        width: wp(90),
        //height: hp(25),
        margin: 10
    },
    paymentContainer: {
        width: wp(80),
        alignSelf: "center"
    },    
    listContainer: {
        flexDirection: "row",
        justifyContent: "space-between"
    },
    btnContainer: {
        backgroundColor: "#FFFFFF",
        width: wp(90),
        alignSelf: "center",
        //flexDirection: "row",
        justifyContent: "center",
        alignItems: "center"
    },
    greyline: {
        backgroundColor: "lightgrey",
        color: "lightgrey",
        alignSelf: "center",
        width: wp(80),
        height: hp(0.2),
        margin: 10,
    },
    txtSmall: {
        color: "#000000",
        fontSize: fp(1.5),
    },
    txtSmallBold: {
        color: "#000000",
        fontSize: fp(1.5),
        fontWeight: "bold"
    },
    txtNormal: {
        color: "#000000",
        fontSize: fp(2),
    },
    txtNormalBold: {
        color: "#000000",
        fontSize: fp(2),
        fontWeight: "bold"
    },
    txtNormalRed: {
        color: "red",
        fontSize: fp(2),
    },
    txtLarge: {
        color: "#000000",
        fontSize: fp(2.2),
    },
    txtLargeBold: {
        color: "#000000",
        fontSize: fp(2.2),
        fontWeight: "bold"
    },
    costContainer: {
        backgroundColor: "#FFFFFF",
        width:wp(80),
        height: hp(25),
        justifyContent: "center",
        alignSelf: "center",
        alignItems: "center",
    },
    imgContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(20),
        justifyContent: "center",
        alignItems: "center"
    },
    thumbPic: {
        width: wp(15),
        height: hp(7),
        borderRadius: 25,
        marginRight: 10
    },
})