import React from 'react';
import { StyleSheet, View } from 'react-native';
import MapView, { Marker } from 'react-native-maps';

export default function App() {
  return (
    <View style={styles.container}>
      <MapView
        style={styles.map}
        initialRegion={{
          latitude: 37.7749, // Latitude of your chosen location
          longitude: -122.4194, // Longitude of your chosen location
          latitudeDelta: 0.05, // Zoom level
          longitudeDelta: 0.05, // Zoom level
        }}
      >
        {/* Optional: Add a marker */}
        <Marker
          coordinate={{ latitude: 37.7749, longitude: -122.4194 }}
          title="San Francisco"
          description="This is a marker description."
        />
      </MapView>
    </View>
  );
}

const styles = StyleSheet.create({
  container: {
    flex: 1,
  },
  map: {
    flex: 1,
  },
});
