import { StyleSheet, Text, View, Image } from 'react-native'
import React from 'react'
import { fp, hp, wp } from '../../helpers/Dimensions'
import Header from '../../components/Header'
import { CIRCLE, LOGO } from '../../assets/Icon'
import Buttonblack from '../../components/Buttonblack'
import { useNavigation } from '@react-navigation/native'


const Inspectionpoints = () => {
    const navigation = useNavigation()
    return (
        <View style={styles.mainContainer}>
            <Header title="Inspection Points" link="Documents" />
            <View style={styles.imgContainer}>
                <Image source={LOGO} />
            </View>
            <View style={styles.inspBoxContainer}>
                <View style={{ width: wp(15), paddingLeft: 5 }}>
                    <Image source={CIRCLE} />
                </View>
                <View style={{ width: wp(85) }}>
                    <Text style={styles.textH2}>Headlights</Text>
                </View>
            </View>
            <View style={styles.photoContainer}>
                <View style={styles.photo}></View>
                <View style={styles.photo}></View>
                <View style={{ width: wp(50) }}></View>

            </View>
            <View style={styles.inspBoxContainer}>
                <View style={{ width: wp(15), paddingLeft: 5 }}>
                    <Image source={CIRCLE} />
                </View>
                <View style={{ width: wp(85) }}>
                    <Text style={styles.textH2}>Air lights</Text>
                </View>
            </View>
            <View style={styles.inspBoxContainer}>
                <View style={{ width: wp(15), paddingLeft: 5 }}>
                    <Image source={CIRCLE} />
                </View>
                <View style={{ width: wp(85) }}>
                    <Text style={styles.textH2}>Stop lights</Text>
                </View>
            </View>
            <View style={styles.inspBoxContainer}>
                <View style={{ width: wp(15), paddingLeft: 5 }}>
                    <Image source={CIRCLE} />
                </View>
                <View style={{ width: wp(85) }}>
                    <Text style={styles.textH2}>Windsheild</Text>
                </View>
            </View>
            <View style={styles.inspBoxContainer}>
                <View style={{ width: wp(15), paddingLeft: 5 }}>
                    <Image source={CIRCLE} />
                </View>
                <View style={{ width: wp(85) }}>
                    <Text style={styles.textH2}>Safety belt for driver and passangers</Text>
                </View>
            </View>
            <View style={styles.inspBoxContainer}>
                <View style={{ width: wp(15), paddingLeft: 5 }}>
                    <Image source={CIRCLE} />
                </View>
                <View style={{ width: wp(85) }}>
                    <Text style={styles.textH2}>Windsheild Wipers</Text>
                </View>
            </View>
            <View style={styles.inspBoxContainer}>
                <View style={{ width: wp(15), paddingLeft: 5 }}>
                    <Image source={CIRCLE} />
                </View>
                <View style={{ width: wp(85) }}>
                    <Text style={styles.textH2}>Tires incl thread depth</Text>
                </View>
            </View>
            <View style={styles.inspBoxContainer}>
                <View style={{ width: wp(15), paddingLeft: 5 }}>
                    <Image source={CIRCLE} />
                </View>
                <View style={{ width: wp(85) }}>
                    <Text style={styles.textH2}>Sppedometer</Text>
                </View>
            </View>
            <Buttonblack title="Next" wide="90" onPress={() => navigation.navigate("Legalconsent")} />
        </View>

    )
}

export default Inspectionpoints

const styles = StyleSheet.create({
    mainContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(100),
        widht: wp(100)
    },
    imgContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(20),
        justifyContent: "center",
        alignItems: "center"
    },
    inspBoxContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(6.5),
        width: wp(100),
        alignItems: "center",
        flexDirection: "row",
        justifyContent: "space-evenly",
        alignSelf: "center"
    },
    photoContainer: {
        backgroundColor: "#FFFFFF",
        width: wp(90),
        height: hp(7),
        flexDirection: "row",
        justifyContent: "space-evenly",
        alignSelf: "center"
    },
    photo: {
        backgroundColor: "lightgrey",
        borderRadius: 10,
        height: hp(7),
        width: wp(15)
    },
    textH2: {
        fontSize: fp(2),
        fontWeight: "bold",
        color: "#000000",
        //paddingLeft: 5
    },
    textNormal: {
        fontSize: fp(1.5),
        color: "#000000"
    },



})