import { Image, StyleSheet, Text, View, Switch, ActivityIndicator } from 'react-native'
import React, { useState } from 'react'
import { fp, hp, wp } from '../../helpers/Dimensions'
import Footer from '../../components/Footer'
import Header from '../../components/Header'
import { DROPICON, MAN, PHONECALL, PICKICON, STAR } from '../../assets/Icon'
import Buttonwhite from '../../components/Buttonwhite'
import Buttonblack from '../../components/Buttonblack'
import { useNavigation } from '@react-navigation/native'
import { DashboardHook } from '../../hooks/DashboardHook'
import InitiateRides from '../../components/InitiateRides'


const Home = () => {
    //const [isEnabled, setIsEnabled] = useState(false);
    //const toggleSwitch = () => setIsEnabled(previousState => !previousState);

    const navigation = useNavigation()

    const { 
            stats, 
            loading, 
            login_dtl_storage, 
            driver_location,
            initiate_rides,
            isEnabled, 
            toggleSwitch
        } = DashboardHook();

    if (loading) {
        return (
            <View>
                <ActivityIndicator size="large" color="#0000ff" />
            </View>
        );
    }

    return (
        <View style={styles.mainContainer}>
            <Header />
            <View style={styles.contentContainer}>
                <View style={styles.statusContainer}>
                    <Text style={styles.txtNormalBold}>{isEnabled ? 'You are online' : 'You are offline'}</Text>
                    <Switch
                        trackColor={{ false: '#CCCCCC', true: '#CCCCCC' }}
                        thumbColor={isEnabled ? 'green' : 'red'}
                        ios_backgroundColor="#3e3e3e"
                        onValueChange={toggleSwitch}
                        value={isEnabled == 1}
                    />
                </View>
                <View style={styles.statsContainer}>
            
                    <View style={styles.rideRatingContainer}>
                        <View style={[styles.conContainer, {width: wp(40)}]}>
                        <Text style={styles.txtSmallBold}>Total</Text>
                        <Text style={styles.txtNormalBold}>{stats?.currency_icon}{stats?.total_earnings}</Text>
                        </View>
                        <View style={[styles.conContainer, {width: wp(30)}]}>
                        <Text style={styles.txtSmallBold}>Today </Text>
                        <Text style={styles.txtNormalBold}>{stats?.currency_icon}{stats?.today_earnings}</Text>
                        </View>
                    </View>
                    <View style={styles.rideRatingContainer}>
                        <View style={[styles.conContainer, {width: wp(40)}]}>
                        <Text style={styles.txtSmallBold}>Total Rides</Text>
                        <Text style={styles.txtNormalBold}>{stats?.total_rides}</Text>
                        </View>
                        <View style={[styles.conContainer, {width: wp(30)}]}>
                        <Text style={styles.txtSmallBold}>Rating</Text>
                        <Text style={styles.txtNormalBold}>{stats?.rating}</Text>
                        </View>
                    </View>

                </View>
                
                <View style={{ flex: 1 }}>
                    <InitiateRides rides={initiate_rides} />
                </View>

            </View>
            <Footer />
        </View>
    )
}

export default Home

const styles = StyleSheet.create({
    mainContainer: {
        width: wp(100),
        height: hp(100)
    },
    contentContainer: {
        backgroundColor: "#F5F5F5",
        width: wp(100),
        height: hp(78)
    },
    statusContainer: {
        backgroundColor: "#FFFFFF",
        width: wp(95),
        height: hp(8),
        flexDirection: "row",
        alignSelf: "center",
        alignItems: "center",
        justifyContent: "space-between",
        borderRadius: 20,        
        padding: 20,
        margin: 7
    },
    statsContainer: {
        backgroundColor: "#FFFFFF",
        width: wp(95),
        height: hp(22),
        alignSelf: "center",
        alignItems: "center",
        justifyContent: "space-between",
        borderRadius: 20,
        padding: 20,
        margin: 7
    },    
    rideRatingContainer: {
        flexDirection: "row",
        width: wp(80),
        alignSelf: "center",
        justifyContent: "space-between"
    },
    conContainer: {
        //width: wp(80),
        height: hp(7),
        flexDirection: "row",
        alignItems: "center",
        justifyContent: "space-between",
        borderRadius: 10,
        borderColor: "#FFC727",
        borderWidth: 1,
        padding: 7,
        //margin: 7
    },
    requestContainer: {
        backgroundColor: "#FFFFFF",
        width: wp(95),
        height: hp(38),
        borderRadius: 20,
        alignSelf: "center",
        paddingTop: 10
    },
    requestView: {
        backgroundColor: "#FFFFFF",
        flexDirection: "row",
        justifyContent: "space-between",
        width: wp(90),
        //height: hp(25),
        margin: 10
    },
    locationView: {
        backgroundColor: "#FFFFFF",
        //width: wp(90),
        //alignSelf: "center",
        flexDirection: "row",
        justifyContent: "space-between"
    },
    buttonContainer: {
        backgroundColor: "#FFFFFF",
        width: wp(90),
        alignSelf: "center",
        flexDirection: "row",
        justifyContent: "space-around",
        alignItems: "center"
    },
    starContainer: {
        width: wp(30),
        flexDirection: "row",
        justifyContent: "space-evenly"
    },
    txtSmall: {
        color: "#000000",
        fontSize: fp(1.5),
    },
    txtSmallBold: {
        color: "#000000",
        fontSize: fp(1.5),
        fontWeight: "bold"
    },    
    txtNormal: {
        color: "#000000",
        fontSize: fp(2),
    },
    txtNormalBold: {
        color: "#000000",
        fontSize: fp(2),
        fontWeight: "bold"
    },
    txtLarge: {
        color: "#000000",
        fontSize: fp(2.2),
    },
    txtLargeBold: {
        color: "#000000",
        fontSize: fp(2.2),
        fontWeight: "bold"
    }
})