import { StyleSheet, Text, View, Image } from 'react-native'
import React from 'react'
import { fp, hp, wp } from '../../helpers/Dimensions'
import Header from '../../components/Header'
import { LOGO } from '../../assets/Icon'
import Textbox from '../../components/Textbox'
import Buttonblack from '../../components/Buttonblack'
import { useNavigation } from '@react-navigation/native'


const Bank = () => {
    const navigation = useNavigation()

    return (
        <View style={styles.mainContainer}>
            <Header title="Bank" link="Documents" />
            <View style={styles.imgContainer}>
                <Image source={LOGO} />
            </View>
            <View style={styles.textBoxContainer}>
                <Text style={styles.label}>Select Bank</Text>
                <Textbox title="Select Bank" wide="90" />
                <Text style={styles.label}>Account Holder</Text>
                <Textbox title="Account Holder Name" wide="90" />
                <Text style={styles.label}>Account Number</Text>
                <Textbox title="Account Number" wide="90" />
                <Text style={styles.label}>Confirm Account Number</Text>
                <Textbox title="Confirm Account Number" wide="90" />
                <Text style={styles.label}>Routing Number</Text>
                <Textbox title="Routing Number" wide="90" />
                <Text style={styles.label}>Account Type</Text>
                <Textbox title="Account Type" wide="90" />
            </View>
            <Buttonblack title="Submit" wide="90" onPress={() => navigation.navigate("Location")} />
        </View>

    )
}

export default Bank

const styles = StyleSheet.create({
    mainContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(100),
        widht: wp(100)
    },
    imgContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(20),
        justifyContent: "center",
        alignItems: "center"
    },
    textBoxContainer: {
        backgroundColor: "#FFFFFF",
        width: wp(90),
        alignSelf: "center"
    },
    label: {
        fontSize: fp(1.5)
    },
    textH2: {
        fontSize: fp(2),
        fontWeight: "bold",
        color: "#000000",
        //paddingLeft: 5
    },
    textNormal: {
        fontSize: fp(1.5),
        color: "#000000"
    },

})