import { StyleSheet, Text, View, TouchableOpacity } from 'react-native'
import React from 'react'
import { fp, hp, wp } from '../helpers/Dimensions'

const Buttonwhite = (props) => {
    const { title, wide } = props

    return (
        <TouchableOpacity {...props}>
            <View style={styles.btnContainer}>
                <View style={[styles.btnBlack, { width: wp(wide) }]}>
                    <Text style={styles.btnWhiteText}>{title}</Text>
                </View>
            </View>
        </TouchableOpacity>
    )
}

export default Buttonwhite

const styles = StyleSheet.create({
    btnContainer: {
        //width: wp(100),
        height: hp(7.5),
        alignItems: "center",
        justifyContent: "center"
    },
    btnBlack: {
        //width: wp(90),
        marginTop: 5,
        marginBottom: 5,
        padding: 15,
        borderRadius: 15,
        textAlign: "center",
        backgroundColor: "#FFFFFF",
        borderWidth: 2,
        borderColor: "#223138",
    },
    btnWhiteText: {
        textAlign: "center",
        color: "#223138",
        fontSize: fp(2),
        fontWeight: "bold"
    }


})