import { StyleSheet, Text, View, Image, TouchableOpacity, Modal } from 'react-native'
import React, { useState } from 'react'
import { fp, hp, wp } from '../helpers/Dimensions'
import { useNavigation } from '@react-navigation/native'
import { BACK, CLOSE, HEMBERGER, HOME, INCIDENT, LIST, LOGOUT } from '../assets/Icon'

const Headerback = (props) => {
    const { title, link } = props
    const [modalVisible1, setModalVisible1] = useState(false);

    const navigation = useNavigation();

    return (
        <View style={styles.mainContainer}>
            <View style={styles.headerContainer}>
                <TouchableOpacity onPress={() => navigation.navigate(link)}>
                    <Image source={BACK} />
                </TouchableOpacity>
                <Text style={styles.textH2}>{title}</Text>
                <View style={{ width: 24 }} />
            </View>
            <Modal
                animationType="leftslide"
                transparent={true}
                visible={modalVisible1}
            >
                <View style={styles.modalContainer}>
                    <View style={styles.modalView}>
                        <TouchableOpacity onPress={() => setModalVisible1(false)}>
                            <View style={{ alignItems: "flex-end", paddingRight: 20 }}>
                                <Image source={CLOSE} />
                            </View>
                        </TouchableOpacity>
                        <TouchableOpacity onPress={() => navigation.navigate("Dashboard")}>
                            <View style={styles.listContainer}>
                                <Image source={HOME} />
                                <Text style={styles.textH1}>Home</Text>
                            </View>
                        </TouchableOpacity>
                        <TouchableOpacity onPress={() => navigation.navigate("Profile")}>
                            <View style={styles.listContainer}>
                                <Image source={HOME} />
                                <Text style={styles.textH1}>Profile</Text>
                            </View>
                        </TouchableOpacity>
                        <TouchableOpacity onPress={() => navigation.navigate("Myrides")}>
                            <View style={styles.listContainer}>
                                <Image source={LIST} />
                                <Text style={styles.textH1}>My Rides</Text>
                            </View>
                        </TouchableOpacity>
                        <TouchableOpacity onPress={() => navigation.navigate("Incident")}>
                            <View style={styles.listContainer}>
                                <Image source={INCIDENT} />
                                <Text style={styles.textH1}>Incident</Text>
                            </View>
                        </TouchableOpacity>
                        <TouchableOpacity onPress={() => navigation.navigate("Login")}>
                            <View style={styles.listContainer}>
                                <Image source={LOGOUT} />
                                <Text style={styles.textH1}>Logout</Text>
                            </View>
                        </TouchableOpacity>
                    </View>
                </View>
            </Modal>
        </View>
    )
}

export default Headerback

const styles = StyleSheet.create({
    mainContainer: {
        background: "red",
        width: wp(100),
        //height: hp(10),

    },
    headerContainer: {
        //backgroundColor: "lightgrey",
        flexDirection: 'row',
        alignItems: 'center',
        justifyContent: "space-between",
        padding: 10,
        //backgroundColor: "#F4A736",
        //height: hp(12),
        width: wp(100),
        //paddingTop: 15,

    },
    textH1: {
        color: "#000000",
        fontWeight: "bold",
        fontSize: fp(2),
        alignItems: "center",
        textAlign: "center",
        paddingLeft: 10
    },
    textH2: {
        color: "#000000",
        fontWeight: "bold",
        fontSize: fp(3),
        alignItems: "center",
        textAlign: "center"
    },
    modalContainer: {
        //flex: 1,
        justifyContent: "flex-start",
        alignItems: "flex-start",
        marginTop: 20,
        width: wp(50)
    },
    modalView: {
        backgroundColor: "#FFFFFF",
        borderWidth: 1,
        borderColor: "grey",
        width: wp(50),
        height: hp(30),
        alignSelf: "center",
        paddingTop: 10
    },
    listContainer: {
        backgroundColor: "#FFFFFF",
        flexDirection: "row",
        justifyContent: "flex-start",
        margin: 10
    }

})