import { StyleSheet, Text, View, TouchableOpacity, Image, Modal } from 'react-native'
import React, { useEffect, useState } from 'react'
import { fp, hp, wp } from '../helpers/Dimensions'
import { useNavigation } from '@react-navigation/native'
import { BACK, CLOSE, HEMBERGER, HOME, INCIDENT, LIST, LOGOUT, MAN } from '../assets/Icon'
import { getFromStorage } from '../utils/storageHelper';

const Header = (props) => {

    const { title, link } = props
    const [modalVisible1, setModalVisible1] = useState(false);
    const [login_dtl_storage, set_login_dtl_storage] = useState(null); 

    const navigation = useNavigation();

    useEffect(() => {
            fetchStorage();
            
        }, []);
    
        const fetchStorage = async () => {
            const storedData = await getFromStorage('login_dtl');
            const storeParse = JSON.parse(storedData);
            set_login_dtl_storage(storeParse);
        };

    return (
        <View style={styles.mainContainer}>
            <View style={styles.profileContainer}>
                <Image source={MAN} style={styles.profilePic} />
                <View>
                    <Text style={styles.txtNormalBold}>Welcome,</Text>
                    <Text style={styles.txtLarge}>{login_dtl_storage?.name}</Text>
                </View>
            </View>
            
        </View>
    )
}

export default Header

const styles = StyleSheet.create({
    mainContainer: {
        backgroundColor: "#FFC727",
        width: wp(100),
        height: hp(12),
        borderBottomEndRadius: 20,
        borderBottomLeftRadius: 20,
        flexDirection: "row"
    },
    profileContainer: {
        width: wp(60),
        flexDirection: "row",
        alignItems: "center",
        justifyContent: "center"
    },
    earningContainer: {
        width: wp(40),
        alignItems: "center",
        justifyContent: "center"
    }, 
    profilePic: {
        width: wp(15),
        height: hp(7),
        borderRadius: 25,
        marginRight: 10
    },
    txtNormal: {
        color: "#000000",
        fontSize: fp(2),
    },
    txtNormalBold: {
        color: "#000000",
        fontSize: fp(2),
        fontWeight: "bold"
    },
    txtLarge: {
        color: "#000000",
        fontSize: fp(2.2),        
    },
    txtLargeBold: {
        color: "#000000",
        fontSize: fp(2.2),   
        fontWeight: "bold"             
    }    
})